$(document).ready( function(){
	
	// Add the hidden cost field
	
	$('#submit-section').prepend('<input type="hidden" name="cost" id="cost">');
	
	// Base variables 
	
	var basePrice = 50; // for standard scripts 1 
	var discount = 0; // enter 10 for 10% 
	
	// Set value of total cost to base price
	
	$('#cost').val(basePrice);
	
	// Function to calculate cost of additional scripts 
	
	function calculateCost() {
	
		// Define variables
		var scriptsCost = 0;
		var totalCost = 0;
		var priceBacket = 25; // £25 per 250 words
			
		// go through each input with class .scrp
		$('.scrp').each(function(i) {
		
			// if this input has more than 1 character
			if(this.value.length > 0){ 
				var charCount = this.value.length-1; // -1 here so next price bracket kicks in after 250 char increments
				var xtimes = (Math.floor(charCount / 250)+1); // +1 so xtimes starts at 1 and not 0
				var thisCost = xtimes * priceBacket;
				scriptsCost += thisCost;
			}
		});
		
		// Calculate total cost. Base price plus additional script costs
		totalCost = scriptsCost + basePrice;
		
		// Implement discount
		if(discount > 0) totalCost = totalCost * (1-discount/100);
		
		// Update cost input with total cost
		$('#cost').val(totalCost);
	
	}
	
	// Triger cost calculation on script input
	
	$('.scrp').on('input', function(){
		calculateCost();
	});
	
	
	// Recalcualte cost if script deleted
	
	$('#del').on('click', function(){
		calculateCost();
	});
	
	
});